/******************************************************************************
*  Do not modify this file!
*  This file is auto-generated.
*  Any changes will be lost.
*  This interface is defined in model.xml
******************************************************************************/
#ifndef MEETINGMGRCONTROLLER_H
#define MEETINGMGRCONTROLLER_H

#include <string>
#include "csfunified/library/CSFUnified.h"
#include "csfunified/services/interface/UnifiedBusinessObject.h"
#include "csfunified/services/interface/MailServiceType.h"

namespace CSFUnified
{
    class MeetingCallback;

/**
    @class MeetingMgrControllerObserver
    This interface when implemented allows you to act as an observer for the MeetingMgrController class via its addObserver Method
    and receive notifications of property changes. Alternatively you use the property notifier mechanism instead and
    listen to events on a single property individually.
*/

    class CSFUNIFIED_API MeetingMgrControllerObserver : virtual public UnifiedBusinessObjectObserver
    {
        public:
        

        
    
        virtual void OnOnlineSwitchChanged() = 0;
        virtual void OnOfflineSwitchChanged() = 0;
	


/**    
    Gives the name of this observer for logging and wrapping purposes    
*/
        virtual std::string getInterfaceName()
        {
            return "MeetingMgrControllerObserver";
        }

    };
/**
    @class MeetingMgrControllerNotifiers
    This class gives you access to a single notifer object for each property on the MeetingMgrController class.
    With these you may listen to individual property changes. Alternatively you may use the observer pattern
    via the MeetingMgrControllerObserver class
*/

    class CSFUNIFIED_API MeetingMgrControllerNotifiers : virtual public UnifiedBusinessObjectNotifiers
    {
        public:

        

         
    
    /**    
        Returns the notifier for the OnlineSwitch property
    */
        virtual SMART_PTR_NS::shared_ptr<PropertyNotifier> getOnlineSwitchNotifier() =0;
    /**    
        Returns the notifier for the OfflineSwitch property
    */
        virtual SMART_PTR_NS::shared_ptr<PropertyNotifier> getOfflineSwitchNotifier() =0;
	

    };
    

	class CSFUNIFIED_API MeetingMgrController : virtual public UnifiedBusinessObject
    {
        public:

        


        using UnifiedBusinessObject::addObserver;
        using UnifiedBusinessObject::removeObserver;

/**    
    Adds an observer to this class who will be notified when property changes occur    
*/
        virtual void addObserver(SMART_PTR_NS::weak_ptr<MeetingMgrControllerObserver> observer) =0;
/**    
    Removes an observer and stops property change notification from being issued to them   
*/
        virtual void removeObserver(SMART_PTR_NS::weak_ptr<MeetingMgrControllerObserver> observer) =0;
 
/**    
    Gets the notifiers object for this class which allows access to a property change notifier for each property on the class.
*/       
        virtual SMART_PTR_NS::shared_ptr<MeetingMgrControllerNotifiers> getMeetingMgrControllerNotifiers() = 0;

        
    
        virtual bool getOnlineSwitch() = 0;
        virtual bool getOfflineSwitch() = 0;
	


        
    
        virtual void registerMeetingCallback(SMART_PTR_NS::shared_ptr<MeetingCallback> meetingCallback) = 0;
        virtual void unregisterMeetingCallback(SMART_PTR_NS::shared_ptr<MeetingCallback> meetingCallback) = 0;
        virtual bool isMeetingInProgress(std::string meetingID) = 0;
        virtual void getCMRInfo(std::string meetingKeyList) = 0;
        virtual unsigned long listMeetings(int year, int month, int day) = 0;
        virtual unsigned long refreshMeetings() = 0;
        virtual bool todayChanged(bool bForceChanged) = 0;
        virtual unsigned long getMeetingDetail(std::string meetingID) = 0;
        virtual unsigned long viewMeetingById(std::string meetingID) = 0;
        virtual bool isInMeeting() = 0;
        virtual bool canStartMeeting() = 0;
        virtual bool canJoinMeeting() = 0;
        virtual unsigned long launchMeetingById(std::string meetingID) = 0;
        virtual bool startInstantMeeting(std::string meetingName, SMART_PTR_NS::shared_ptr<std::vector<std::string> > vecInviteList) = 0;
        virtual bool inviteToInstantMeeting(std::string attendeeName) = 0;
        virtual bool acceptInstantMeeting(std::string sessioName) = 0;
        virtual bool declineInstantMeeting(std::string sessioName) = 0;
        virtual void editInstantMeetingSetting() = 0;
        virtual unsigned long sendEmail(std::string tos, std::string subject, std::string body, std::string meetingKey) = 0;
        virtual int getInstantMeetingLastErrCode() = 0;
        virtual bool startJoinMeetingByUrl(std::string strURL) = 0;
        virtual std::string sendMeetingInvitation(std::string attendees, std::string meetingID, std::string msg) = 0;
        virtual void setMeetingReminderEnable(bool isEnable) = 0;
        virtual std::string sendMeetingReminder(std::string attendees, std::string meetingID, std::string msg) = 0;
        virtual MailServiceTypeEnum::MailServiceType getCurrentMailType() = 0;
        virtual bool openMeetingDetailPage(std::string strURL) = 0;



/**    
    Gives the name of this business object for logging and wrapping purposes    
*/
        virtual std::string getInterfaceName()
        {
            return "MeetingMgrController";
        }

    };
    
}

#endif